using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace CollDetect
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            collView1.loadModel("teapot");
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            collView1.repaint();
        }

        Point prevMouse;
        double deltaX = 0, deltaY = 0;
        private void Form1_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                if (prevMouse.X == -1)
                {
                    //label1.Text = "Just down";
                    prevMouse = e.Location;
                }
                else
                {
                    deltaX += e.X - prevMouse.X;
                    deltaY += e.Y - prevMouse.Y;
                    label1.Text = "Delta is " + deltaX + ", " + deltaY;
                    prevMouse = e.Location;
                    collView1.look(deltaX / 100, deltaY / 100);
                }
            }
            else
            {
                prevMouse = new Point(-1, -1);
                //label1.Text = "Sphere loc (" + collView1.sphereLoc[0] + ", " + collView1.sphereLoc[1] + ", " + collView1.sphereLoc[2] + ")";
            }
        }

        private void Form1_KeyPress(object sender, KeyPressEventArgs e)
        {
        }

        private void Form1_KeyDown(object sender, KeyEventArgs e)
        {
        }

        private void CheckCollide()
        {
            if (collView1.CheckCollide())
                label1.Text = "COLLIDED";
            else
                label1.Text = "NOT COLLIDED";
        }
        private void button1_Click(object sender, EventArgs e)
        {
            collView1.sphereLoc[2] += 0.1;
            CheckCollide();
        }

        private void button4_Click(object sender, EventArgs e)
        {
            collView1.sphereLoc[0] -= 0.1;
            CheckCollide();
        }

        private void button2_Click(object sender, EventArgs e)
        {
            collView1.sphereLoc[2] -= 0.1;
            CheckCollide();
        }

        private void button3_Click(object sender, EventArgs e)
        {
            collView1.sphereLoc[0] += 0.1;
            CheckCollide();
        }

        private void button5_Click(object sender, EventArgs e)
        {
            collView1.sphereLoc[1] += 0.1;
            CheckCollide();
        }

        private void button6_Click(object sender, EventArgs e)
        {
            collView1.sphereLoc[1] -= 0.1;
            CheckCollide();
        }
    }
}