using System;
using System.Collections.Generic;
using System.Collections;
using System.Text;
using CsGL.OpenGL;


namespace CollDetect
{
    class NaiveCollide
    {
        public ArrayList polyList;
        public NaiveCollide()
        {
            polyList = new ArrayList();
        }

        public void Add(Polygon p)
        {
            polyList.Add(p);
        }

        public bool isCollide(double[] prevPoint, double[] curPoint)
        {
            bool collided = false;
            foreach (Polygon p in polyList)
            {
                if (p.isCollide(prevPoint, curPoint)) 
                    collided = true;
            }
            return collided;
        }

        public void Render()
        {
            GL.glBegin(GL.GL_TRIANGLES);
            foreach(Polygon p in polyList)
                p.Render();
            GL.glEnd();

        }

    }
    class Polygon
    {
        double[] v0;
        double[] v1;
        double[] v2;
        double[] nn;
        double d;

        bool colliding = false;

        public Polygon(double[] v0, double[] v1, double[] v2)
        {
            this.v0 = v0;
            this.v1 = v1;
            this.v2 = v2;
            this.nn = normal(v0, v1, v2);
            this.d = -(nn[0] * v0[0] + nn[1] * v0[1] + nn[2] * v0[2]);
        }
        public bool isCollide(double[] prevPoint, double[] curPoint)
        {
            double p0 = v2[0] - curPoint[0];
            double p1 = v2[1] - curPoint[1];
            double p2 = v2[2] - curPoint[2];
            double distance = p0 * nn[0] + p1 * nn[1] + p2 * nn[2];
            if (Math.Abs(distance) < 0.2)
            {
                double[] iPoint = new double[] { curPoint[0] - distance * nn[0], curPoint[1] - distance * nn[1], curPoint[2] - distance * nn[2] };
                int nx, ny;
                if (Math.Abs(nn[2]) >= Math.Abs(nn[1]) && Math.Abs(nn[2]) >= Math.Abs(nn[0]))
                {
                    nx = 0; ny = 1;
                }
                else if (Math.Abs(nn[1]) >= Math.Abs(nn[0]) && Math.Abs(nn[1]) >= Math.Abs(nn[2]))
                {
                    nx = 0; ny = 2;
                }
                else
                {
                    nx = 1; ny = 2;
                }
                double x0, x1, x2, y0, y1, y2, x, y;
                x0 = v2[nx]; x1 = v1[nx]; x2 = v0[nx]; y0 = v2[ny]; y1 = v1[ny]; y2 = v0[ny];
                x = iPoint[nx]; y = iPoint[ny];
                double a0, a1, a2;
                double b0, b1, b2;
                double c0, c1, c2;
                a0 = x1 * y2 - x2 * y1; a1 = x2 * y0 - x0 * y2; a2 = x0 * y1 - x1 * y0;
                b0 = y1 - y2; b1 = y2 - y0; b2 = y0 - y1;
                c0 = x2 - x1; c1 = x0 - x2; c2 = x1 - x0;
                double det = a0 + x0 * b0 + y0 * c0;

                double t0 = (a0 + b0 * x + c0 * y) / det;
                double t1 = (a1 + b1 * x + c1 * y) / det;
                double t2 = (a2 + b2 * x + c2 * y) / det;

                if (t0 >= 0 && t0 <= 1 && t1 >= 0 && t1 <= 1 && t2 >= 0 && t2 <= 1)
                {
                    colliding = true;
                    return true;
                }
            }
            colliding = false;
            return false;
        }

        public void Render()
        {
            if (colliding)
            {
                GL.glColor3f(1.0f, 0.0f, 0.0f);
            }
            else
            {
                GL.glColor3f(0.5f, 0.5f, 0.5f);
            }
            GL.glNormal3dv(nn);
            GL.glVertex3dv(v0);
            GL.glVertex3dv(v1);
            GL.glVertex3dv(v2);
        }

        // misc. gl functions:
        double[] normalize(double[] v)
        {
            // calculate the length of the vector
            float len = (float)(Math.Sqrt((v[0] * v[0]) + (v[1] * v[1]) + (v[2] * v[2])));

            // avoid division by 0
            if (len == 0.0f)
                len = 1.0f;

            // reduce to unit size
            v[0] /= len;
            v[1] /= len;
            v[2] /= len;
            return v;
        }

        // normal(); - finds a normal vector and normalizes it
        double[] normal(double[] v0, double[] v1, double[] v2)
        {

            double ax, ay, az, bx, by, bz;
            // calculate the vectors A and B
            // note that v[3] is defined with counterclockwise winding in mind
            // a
            ax = v0[0] - v1[0];
            ay = v0[1] - v1[1];
            az = v0[2] - v1[2];
            // b
            bx = v1[0] - v2[0];
            by = v1[1] - v2[1];
            bz = v1[2] - v2[2];

            double[] nn = new double[3];
            // calculate the cross product and place the resulting vector
            // into the address specified by vector_t *normal
            nn[0] = (ay * bz) - (az * by);
            nn[1] = (az * bx) - (ax * bz);
            nn[2] = (ax * by) - (ay * bx);

            // normalize
            return normalize(nn);
        }


    }
}
